<?php

class cryptopro
{
	public $title;
	
	public $site;
	
	function __construct()
	{
		$this->title = TEXT_MODULE_CRYPTOPRO_TITLE;
		$this->site = 'https://www.cryptopro.ru';
		$this->api = 'https://www.cryptopro.ru/support/docs';
		$this->version = '1.0';
	}
	
	public function configuration()
	{
		$cfg = array();
		
		$choices = [];
		$fields_query = db_query("select id, name from app_fields where entities_id = 1 and type in ('fieldtype_input_protected','fieldtype_input','fieldtype_textarea')");
		while($fields = db_fetch_array($fields_query))
		{
			$choices[$fields['id']] = $fields['name'];
		}
		
		$cfg[] = array(
				'key'	=> 'certificate_imprint',
				'type' => 'dorpdown',
				'choices' => $choices,
				'default' => '',
				'title'	=> TEXT_MODULE_CRYPTOPRO_CERTIFICATE_IMPRINT,				
				'description'	=> TEXT_MODULE_CRYPTOPRO_CERTIFICATE_IMPRINT_INFO,
				'params' =>array('class'=>'form-control input-large required'),				
		);
							
				
		return $cfg;
	}
	
	function select_certificate()
	{
		require('plugins/ext/digital_signature_modules/cryptopro/components/select_certificate.php');
	}
		
	function login($module_id)
	{		
		global $alerts, $app_fields_cache;
						
		$cfg = modules::get_configuration($this->configuration(),$module_id);
						
		if(!isset($app_fields_cache[1][$cfg['certificate_imprint']]))
		{
			$alerts->add('Поле не ' . $cfg['certificate_imprint'] . ' найдено в сущности 1. Проверьте настройки модуля КриптоПро.','error');
			redirect_to('users/signature_login');
		}
		
		//print_rr($_POST);
		
		$cert_username = db_prepare_input($_POST['cert_username']);
			
		$user_query = db_query("select id, field_{$cfg['certificate_imprint']} from app_entity_1 where length(field_{$cfg['certificate_imprint']})>0");
		while($user = db_fetch_array($user_query))
		{						
			$cert=strtolower(trim($user['field_' . $cfg['certificate_imprint']]));
			$calc_hash=hash("sha256",$cert.$_POST['form_session_token']);
						
			if($_POST['sha256_cert_thumbprint'] == $calc_hash)
			{			
				app_session_register('app_logged_users_id',$user['id']);
				
				two_step_verification::approve();					
			}		
		}				
		
		users_login_log::fail($cert_username);
		$alerts->add('Сертификат не зарегистрирован в системе.','error');
		redirect_to('users/signature_login');
		
	}				
	
}